/**
 * 
 */
package com.ejie.ab18a.control.mantenimiento;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.ab18a.model.Ab18aErrorAplicacion;
import com.ejie.ab18a.service.Ab18aErrorAplicacionService;
import com.ejie.ab18a.utils.Constantes;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;

/**
 * @author XXXX
 * 
 */
@Controller
@RequestMapping(value = "/merrores")
public class Ab18aErrorMtoController {

	/** The Constant logger. */
	private static final Logger logger = LoggerFactory.getLogger(Ab18aErrorMtoController.class);

	@Autowired
	private Ab18aErrorAplicacionService ab18aErrorAplicacionService;

	@Autowired
	private ReloadableResourceBundleMessageSource messageSource;

	// @Autowired
	// private Ab18ARecogidaInformacionImpl proxy;

	@RequestMapping(value = "mantenimiento", method = RequestMethod.GET)
	public String viewMantenimiento() {
		logger.info("mantenimiento de Errores");
		return "ab18aErrorMantenimiento";
	}

	/**
	 * Buscamos los boletines correspondientes a los valores del filtro
	 **/
	@RequestMapping(value = "mantenimiento/tabla", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridResponseDto<Ab18aErrorAplicacion> buscarErrores(@ModelAttribute() Ab18aErrorAplicacion errorFiltro,
			@ModelAttribute() JQGridRequestDto request) {

		// RecogidaInformacionRequest requestProx = new
		// RecogidaInformacionRequest();
		// requestProx.setIdOrigen(new Long("10926"));
		// requestProx.setIdOrigenAplicacion(1);
		// requestProx.setIdTicket(13);
		// requestProx.setIdPeticionEnvio(11);
		// RecogidaInformacionResponse responseProx = null;
		// try {
		// responseProx = this.proxy.solicitarInformacion(requestProx);
		// } catch (Exception e) {
		// e.printStackTrace();
		// }
		//
		// responseProx.getDatosBoletin().getCodEstado();

		List<Ab18aErrorAplicacion> listaApp = new ArrayList<Ab18aErrorAplicacion>();
		Long recordNum = Long.valueOf("12125");
		try {
			listaApp = this.ab18aErrorAplicacionService.findAll(errorFiltro, request);
			recordNum = this.ab18aErrorAplicacionService.findAllCount(errorFiltro);
		} catch (Exception e) {
			Ab18aErrorMtoController.logger
					.error("Ab18aErrorMtoController - buscarErrores() - Error al obtener la lista de los errores de la aplicación - " + e);
		}

		JQGridResponseDto<Ab18aErrorAplicacion> response = new JQGridResponseDto<Ab18aErrorAplicacion>(request, recordNum, listaApp);
		return response;
	}

	/**
	 * Method 'guardarMantenimiento'.
	 * 
	 * @param mantenimiento
	 *            Y96bMantenimiento
	 * @return Y96bMantenimiento
	 * @throws Exception
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Ab18aErrorAplicacion guardarMantenimiento(@RequestBody Ab18aErrorAplicacion mantenimiento, HttpServletResponse response) throws Exception {
		Ab18aErrorAplicacion mantenimientoAux = null;

		if (mantenimiento.getId() != null && mantenimiento.getId() > 0) {
			/**
			 * idRegistro > 0 implica que es una modificación.
			 */
			mantenimientoAux = this.ab18aErrorAplicacionService.update(mantenimiento);
			Ab18aErrorMtoController.logger.info("[POST] : Ab18aErrorAplicacion mantenimiento actualizado correctamente");
		} else {
			if (this.ab18aErrorAplicacionService.findErrorByCod(mantenimiento.getCodError()) <= 0) {
				/**
				 * Si tenemos idRegistro vacío es un alta de registro
				 */
				try {
					mantenimientoAux = this.ab18aErrorAplicacionService.add(mantenimiento);
					Ab18aErrorMtoController.logger.info("[POST] : Ab18aErrorAplicacion mantenimiento insertado correctamente");
				} catch (Exception e) {
					Ab18aErrorMtoController.logger.error("[POST] : Ab18aErrorAplicacion error al añadir un registro al mantenimiento: " + e);
					throw e;
				}
			} else {
				response.sendError(Constantes.HTTP_STATUS_EXPECTATION_FAILED,
						this.messageSource.getMessage("mantenimientos.validacion.codigoRepetido", null, LocaleContextHolder.getLocale()));
			}
		}

		return mantenimientoAux;
	}

	/**
	 * @param messageSource
	 *            ReloadableResourceBundleMessageSource-.
	 */
	public void setMessageSource(ReloadableResourceBundleMessageSource messageSource) {
		this.messageSource = messageSource;
	}
}
